/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: AsiApm_Public.h $
   Last Modification:
    $Id: AsiApm_Public.h 6674 2010-03-22 10:23:37Z AndreasB $

    $Author: Eric $
    $Modtime: 11.09.08 8:27 $
    $Revision: 0 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    AS-Interface Master application task public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     1          15.01.09    ES
        Created

**************************************************************************************/
/**
 * @file AsiApm_Public.h
 *  AS-Interface Apm - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __ASI_APM_PUBLIC_H
#define __ASI_APM_PUBLIC_H

#include "AsiMaster_Public.h"

#define ASI_APM_GET_STATE_REQ               0x00005300L
#define ASI_APM_GET_STATE_CNF               0x00005301L

#define ASI_APM_STORE_ACTUAL_CONFIG_REQ     0x00005302L
#define ASI_APM_STORE_ACTUAL_CONFIG_CNF     0x00005303L

#define ASI_APM_STORE_ACTUAL_PARAM_REQ      0x00005304L
#define ASI_APM_STORE_ACTUAL_PARAM_CNF      0x00005305L

#define ASI_APM_SET_LPS_REQ                 0x00005306L
#define ASI_APM_SET_LPS_CNF                 0x00005307L

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'AS-Interface Apm'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 ASI_APM_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(ASI_APM_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define ASI_APM_QUEUE_NAME        "QUE_ASIAPM"

/** @} */

/*************************************************************************************/
/* definitions */

#define ASI_APM_WD_OFF                            0x00000000L
#define ASI_APM_WD_MIN_TIMEOUT                    0x00000014L
#define ASI_APM_WD_MAX_TIMEOUT                    0x0000FFFFL

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__ASI_APM_PACKET)
#endif


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>ASI_APM_GET_STATE_CNF_DATA_Ttag</code> */
typedef struct ASI_APM_GET_STATE_CNF_DATA_Ttag
  ASI_APM_GET_STATE_CNF_DATA_T;

__PACKED_PRE struct ASI_APM_GET_STATE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_APM_SET_LPS_REQ_DATA_Ttag</code> */
typedef struct ASI_APM_SET_LPS_REQ_DATA_Ttag
  ASI_APM_SET_LPS_REQ_DATA_T;

__PACKED_PRE struct ASI_APM_SET_LPS_REQ_DATA_Ttag
{
  TLR_UINT8  abProjectedList[ASI_MASTER_LIST_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>ASI_APM_PCK_GET_STATE_REQ_Ttag</code> */
typedef struct ASI_APM_PCK_GET_STATE_REQ_Ttag
  ASI_APM_PCK_GET_STATE_REQ_T;
/** type of <code>ASI_APM_PCK_GET_STATE_CNF_Ttag</code> */
typedef struct ASI_APM_PCK_GET_STATE_CNF_Ttag
  ASI_APM_PCK_GET_STATE_CNF_T;

__PACKED_PRE struct ASI_APM_PCK_GET_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

__PACKED_PRE struct ASI_APM_PCK_GET_STATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;   /** packet header */
  ASI_APM_GET_STATE_CNF_DATA_T  tData;   /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_APM_PCK_STORE_ACTUAL_CONFIG_REQ_Ttag</code> */
typedef struct ASI_APM_PCK_STORE_ACTUAL_CONFIG_REQ_Ttag
  ASI_APM_PCK_STORE_ACTUAL_CONFIG_REQ_T;
/** type of <code>ASI_APM_PCK_STORE_ACTUAL_CONFIG_CNF_Ttag</code> */
typedef struct ASI_APM_PCK_STORE_ACTUAL_CONFIG_CNF_Ttag
  ASI_APM_PCK_STORE_ACTUAL_CONFIG_CNF_T;

__PACKED_PRE struct ASI_APM_PCK_STORE_ACTUAL_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

__PACKED_PRE struct ASI_APM_PCK_STORE_ACTUAL_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_APM_PCK_STORE_ACTUAL_PARAM_REQ_Ttag</code> */
typedef struct ASI_APM_PCK_STORE_ACTUAL_PARAM_REQ_Ttag
  ASI_APM_PCK_STORE_ACTUAL_PARAM_REQ_T;
/** type of <code>ASI_APM_PCK_STORE_ACTUAL_PARAM_CNF_Ttag</code> */
typedef struct ASI_APM_PCK_STORE_ACTUAL_PARAM_CNF_Ttag
  ASI_APM_PCK_STORE_ACTUAL_PARAM_CNF_T;

__PACKED_PRE struct ASI_APM_PCK_STORE_ACTUAL_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header */

}__PACKED_POST;

__PACKED_PRE struct ASI_APM_PCK_STORE_ACTUAL_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_APM_PCK_SET_LPS_REQ_Ttag</code> */
typedef struct ASI_APM_PCK_SET_LPS_REQ_Ttag
  ASI_APM_PCK_SET_LPS_REQ_T;
/** type of <code>ASI_APM_PCK_SET_LPS_CNF_Ttag</code> */
typedef struct ASI_APM_PCK_SET_LPS_CNF_Ttag
  ASI_APM_PCK_SET_LPS_CNF_T;

__PACKED_PRE struct ASI_APM_PCK_SET_LPS_REQ_Ttag
{
  TLR_PACKET_HEADER_T        tHead; /** packet header */
  ASI_APM_SET_LPS_REQ_DATA_T tData; /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct ASI_APM_PCK_SET_LPS_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header */

}__PACKED_POST;
/*************************************************************************************/

/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__ASI_APM_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __ASI_APM_PUBLIC_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/

